# Rexsel Editor and Compiler #

*Rexsel* is a simplified (compact, non-XML), easy to read version of XSLT,
similar to the relationship between [Relax-NG](https://relaxng.org/) and
its [compact form](https://relaxng.org/compact-20021121.html).

It has been successfully used on the [Paloose site](https://www.paloose.org)
and [Hop Vine Music](https://www.hopvine-music.com/) sites, as well as
the [Rexsel site](https://www.rexsel.org), 
generating all the necessary XSLT transform files.
The actual generation of the XSLT is done when the site is built and uploaded to the server,
rather than being performed on each browser request.

It was conceived after many years of writing XSLT templates for translating XML 
into various forms: XML, XHTML, Swift code, and even LaTeX. While the underlying 
structure is virtually identical to XSLT, it is hoped that the result will help 
users produce more concise, readable stylesheets independent of XML.

```
stylesheet {
    version "1.0"
 
    proc helloWorld {
        element "div" {
            attribute "class"  "simpleBox"
            text "Hello World!"
        }
    }
}
```

This Rexsel editor is a front end for the compiler based on a 
MacOS application rather than as a command
line application (CRexsel). The latter is a Swift Package using
the RexselKernel package, making it 
portable to Linux. Both the command line and kernel can be
built on any system that supports Swift.

![image](rexseleditor-1.png "Editor Panel"){width="90%"}

### Caveats ###

The current version has a Tokenizer that is a little less than optimal and so
could be slower on large files (>800 lines). This will be investigated and
an updated version will be produced when I have the time.

### What is this repository for? ###

Anyone who uses XSLT to transform XML based documents who
wants a more concise approach to designing stylesheets.

### How do I get set up? ###

The editor was built on XCode V16
 
* The package can be downloaded by cloning the repository using

        git clone https://hsfr@bitbucket.org/hsfr/rexseleditor.git

### Who do I talk to? ###

* The author <hsfr@rexsel.com>
* [The oXygen XSLT Forum](https://www.oxygenxml.com/forum/xslt-and-fop/) 
