//
//  Preferences+StringsView.swift
//  HVAccounts
//
//  Created by Hugh Field-Richards on 19/05/2025.
//

import SwiftUI

struct PreferencesStringsView: View {
 
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Main view
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   var body: some View {
      VStack {
         VStack {
            UncompilerScriptView()
               .padding( .init(top: 0, leading: 0, bottom: 3, trailing: 0))
            RexselFileExtensionView()
               .padding( .init(top: 0, leading: 0, bottom: 3, trailing: 0))
            XsltProcessorView()
               .padding( .init(top: 0, leading: 0, bottom: 3, trailing: 0))
            InitialNewDocumentStringView()
            Spacer()
            Button( action: {
               useDefaults()
            } ) {
               Text( "Restore Defaults" )
            }
         }
         .border( Color.gray, width: 0 )
         .padding(EdgeInsets( top: 10, leading: 7, bottom: 5, trailing: 7 ) )
      }
      .padding(EdgeInsets(top: 10, leading: 10, bottom: 0, trailing: 15))
      .frame( width: SettingsView.preferencesPanelDefaultSize.width, alignment: .trailing )
   }
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Functions
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   func useDefaults() {
      // defaultDictionaryContent has all the values in the default list
      // which in stored in HVAccountsProperties.plist in the app resources.
      guard let defaultDictionaryContent = defaultResourceFileDictionary else {
         fatalError( "Could not load default resource file dictionary" )
      }
      
      let initialNewDocumentText = defaultDictionaryContent[KeyProperties.initialNewDocumentTextKey] as! String
      UserDefaults.standard.set( initialNewDocumentText, forKey: KeyProperties.initialNewDocumentTextKey )
      
      let uncompilerDateFormat = defaultDictionaryContent[KeyProperties.unCompilerDateFormatKey] as! String
      UserDefaults.standard.set( uncompilerDateFormat, forKey: KeyProperties.unCompilerDateFormatKey )
      
      let rexselFileExt = defaultDictionaryContent[KeyProperties.rexselFileExtKey] as! String
      UserDefaults.standard.set( rexselFileExt, forKey: KeyProperties.rexselFileExtKey )
      
      let xsltProcessor = defaultDictionaryContent[KeyProperties.xsltProcessorKey] as! String
      UserDefaults.standard.set( xsltProcessor, forKey: KeyProperties.xsltProcessorKey )
      
      // This must be done last (for guard!).
      // The uncompiler script default is contained in the Bundle.
      guard let bundledUncompilerScript = Bundle.main.path(forResource: "xsl2rexsel", ofType: "xsl") else {
         UserDefaults.standard.set("/usr/local/bin/xsl2rexsel.xsl", forKey: KeyProperties.uncompilerScriptKey)
         return
      }
      UserDefaults.standard.set(bundledUncompilerScript, forKey: KeyProperties.uncompilerScriptKey)
   
   }

}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

//#Preview {
//    PreferencesStringsView()
//}

