//
//  InitialNewDocumentStringView.swift
//  HVAccounts
//
//  Created by Hugh Field-Richards on 19/05/2025.
//

import SwiftUI

struct InitialNewDocumentStringView: View {
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - KeyProperties
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   @AppStorage( KeyProperties.initialNewDocumentTextKey ) var initialNewDocumentText: String = ""

   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Main view
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   var body: some View {
      
      VStack {
         HStack {
            Spacer()
            Text( "New Document Text" )
                .font(.system( size: 10, weight: .bold ))
            Spacer()
         }
         .padding( .init(top: 10, leading: 0, bottom: 0, trailing: 0))
         
         TextEditor( text: $initialNewDocumentText )
            .frame( maxWidth: 450, minHeight: 25, alignment: .topLeading )
            .font(.system( size: 12 ))
            .foregroundColor(Color.brown)
            .overlay(
               RoundedRectangle(cornerRadius: 5)
                  .stroke(Color.gray.opacity(0.5), lineWidth: 1)
            )
         
         .padding( .init(top: 10, leading: 0, bottom: 5, trailing: 0))
      }
   }
}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

//#Preview {
//    InitialNewDocumentStringView()
//}

