//
//  RexselFileExtensionView.swift
//  RexselEditor
//
//  Created by Hugh Field-Richards on 03/10/2025.
//

import SwiftUI

struct RexselFileExtensionView: View {
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - KeyProperties
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   @AppStorage( KeyProperties.rexselFileExtKey ) var rexselFileExt: String = "rxsl"

   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Main view
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   var body: some View {
      HStack{
         Text( "Rexsel File Extension" )
            .padding([ .trailing])
            .font(.system( size: 10, weight: .bold ))
         Spacer()
         Text( rexselFileExt )
            .frame( maxWidth: 350, alignment: .trailing )
            .font(.system( size: 10 ))
            .foregroundColor(Color.brown)
         Spacer()
         Button( action: {
            let pathName = rexselFileExt
            if let fileURL = getFolderStartingWith( pathName ) {
               rexselFileExt = fileURL.path()
            }
         } ) { Text( "Change" ) }
      }
      .padding([.leading])
   }
}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

//#Preview {
//   AccountsRootView()
//}
