//
//  UncompilerScriptView.swift
//
//  Created by Hugh Field-Richards on 2/09/2025.
//

import SwiftUI

struct UncompilerScriptView: View {
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - KeyProperties
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   @AppStorage( KeyProperties.uncompilerScriptKey ) var uncompilerScript: String = ""
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Main view
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   var body: some View {
      HStack{
         Text( "Uncompiler Script" )
            .padding([ .trailing])
            .font(.system( size: 10, weight: .bold ))
         Spacer()
         Text( uncompilerScript.preparedFileName )
            .frame( maxWidth: 350, alignment: .trailing )
            .font(.system( size: 10 ))
            .foregroundColor(Color.brown)
         Spacer()
         Button( action: {
            let pathName = uncompilerScript
            if let fileURL = getFolderStartingWith( pathName ) {
               uncompilerScript = fileURL.path()
            }
         } ) { Text( "Change" ) }
      }
      .padding([.leading])
   }
}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

//#Preview {
//   AccountsRootView()
//}
