//
//  XsltProcessorView.swift
//  RexselEditor
//
//  Created by Hugh Field-Richards on 03/10/2025.
//

import SwiftUI

struct XsltProcessorView: View {
   
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - KeyProperties
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   @AppStorage( KeyProperties.xsltProcessorKey ) var xsltProcessor: String = ""

   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // MARK: - Main view
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
   
   var body: some View {
      HStack{
         Text( "XSLT Processor" )
            .padding([ .trailing])
            .font(.system( size: 10, weight: .bold ))
         Spacer()
         Text( xsltProcessor.preparedFileName )
            .frame( maxWidth: 350, alignment: .trailing )
            .font(.system( size: 10 ))
            .foregroundColor(Color.brown)
         Spacer()
         Button( action: {
            let pathName = xsltProcessor
            if let fileURL = getFolderStartingWith( pathName ) {
               xsltProcessor = fileURL.path()
            }
         } ) { Text( "Change" ) }
      }
      .padding([.leading])
   }
}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

//#Preview {
//   AccountsRootView()
//}
