<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" id="xsl-rexsel" xmlns:rng="http://relaxng.org/ns/structure/1.0" xmlns:a="http://relaxng.org/ns/annotation/1.0" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:sch="http://www.ascc.net/xml/schematron">
 <!-- Line: 44 -->
<xsl:output  method="text"/>

 <!-- Line: 54 -->
<xsl:variable  name="versionNumber" select="'1.0.2'"/>

 <!-- Line: 56 -->
<xsl:variable  name="doubleQuote" select="'&#34;'"/>

 <!-- Line: 57 -->
<xsl:variable  name="space" select="' '"/>

 <!-- Line: 58 -->
<xsl:variable  name="ampersand" select="'&#38;'"/>

 <!-- Line: 60 -->
<xsl:variable  name="openCurlyBracket" select="'&#123;'"/>

 <!-- Line: 61 -->
<xsl:variable  name="closeCurlyBracket" select="'&#125;'"/>

 <!-- Line: 63 -->
<xsl:variable  name="solidus" select="'&#47;'"/>

 <!-- Line: 64 -->
<xsl:variable  name="revSolidus" select="'&#92;'"/>

 <!-- Line: 66 -->
<xsl:variable  name="lessThan" select="'&#60;'"/>

 <!-- Line: 67 -->
<xsl:variable  name="greaterThan" select="'&#62;'"/>

 <!-- Line: 69 -->
<xsl:variable  name="identSpaces" select="'    '"/>

 <!-- Line: 70 -->
<xsl:variable  name="return">
 <!-- Line: 70 -->
<xsl:text>
</xsl:text>

</xsl:variable>
 <!-- Line: 77 -->
<xsl:template  match="/">
 <!-- Line: 78 -->
<xsl:value-of  select="concat( '// Uncompiler Version ', $versionNumber, $return )"/>

 <!-- Line: 79 -->
<xsl:text>stylesheet {</xsl:text>
 <!-- Line: 80 -->
<xsl:value-of  select="$return"/>

 <!-- Line: 81 -->
<xsl:apply-templates  select="//xsl:stylesheet/@*" mode="prefix">
 <xsl:with-param  name="spaces" select="$identSpaces"/>


</xsl:apply-templates>
 <!-- Line: 84 -->
<xsl:call-template name="outputNamespaces"/>

 <!-- Line: 85 -->
<xsl:apply-templates  select="//xsl:stylesheet/*">
 <xsl:with-param  name="spaces" select="$identSpaces"/>


</xsl:apply-templates>
 <!-- Line: 88 -->
<xsl:text>}</xsl:text>
 <!-- Line: 89 -->
<xsl:value-of  select="$return"/>


</xsl:template>
 <!-- Line: 95 -->
<xsl:template name="outputNamespaces">
 <!-- Line: 96 -->
<xsl:param  name="spaces"/>

 <!-- Line: 97 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 99 -->
<xsl:for-each select="//xsl:stylesheet/namespace::*">
 <!-- Line: 100 -->
<xsl:variable  name="namespaceName" select="name(.)"/>

 <!-- Line: 101 -->
<xsl:variable  name="namespaceValue" select="."/>

 <!-- Line: 103 -->
<xsl:value-of  select="concat( $newSpaces, 'xmlns ', $doubleQuote, $namespaceName, $doubleQuote )"/>

 <!-- Line: 104 -->
<xsl:value-of  select="concat( $space, $doubleQuote, $namespaceValue, $doubleQuote, $return )"/>


</xsl:for-each>

</xsl:template>
 <!-- Line: 111 -->
<xsl:template  match="@version" mode="prefix">
 <!-- Line: 112 -->
<xsl:param  name="spaces"/>

 <!-- Line: 114 -->
<xsl:value-of  select="concat( $spaces, 'version ', $doubleQuote, ., $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 119 -->
<xsl:template  match="@id" mode="prefix">
 <!-- Line: 120 -->
<xsl:param  name="spaces"/>

 <!-- Line: 122 -->
<xsl:value-of  select="concat( $spaces, 'id ', $doubleQuote, ., $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 127 -->
<xsl:template  mode="prefix" match="@lang">
 <!-- Line: 128 -->
<xsl:param  name="spaces"/>

 <!-- Line: 130 -->
<xsl:value-of  select="concat( $spaces, 'lang ', $doubleQuote, ., $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 135 -->
<xsl:template  match="node() | @*" mode="prefix"/>

 <!-- Line: 140 -->
<xsl:template name="replaceStrings">
 <!-- Line: 141 -->
<xsl:param  name="txt"/>

 <!-- Line: 143 -->
<xsl:choose>
 <!-- Line: 144 -->
<xsl:when test="contains( $txt, $revSolidus )">
 <!-- Line: 145 -->
<xsl:value-of  select="substring-before( $txt, $revSolidus )"/>

 <!-- Line: 146 -->
<xsl:value-of  select="concat( $revSolidus, $revSolidus )"/>

 <!-- Line: 147 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="substring-after( $txt, $revSolidus )"/>


</xsl:call-template>

</xsl:when>
 <!-- Line: 151 -->
<xsl:when test="contains( $txt, $doubleQuote )">
 <!-- Line: 152 -->
<xsl:value-of  select="substring-before( $txt, $doubleQuote )"/>

 <!-- Line: 153 -->
<xsl:value-of  select="concat( $revSolidus, $doubleQuote )"/>

 <!-- Line: 154 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="substring-after( $txt, $doubleQuote )"/>


</xsl:call-template>

</xsl:when>
 <!-- Line: 158 -->
<xsl:when test="contains( $txt, $lessThan )">
 <!-- Line: 159 -->
<xsl:value-of  select="substring-before( $txt, $lessThan )"/>

 <!-- Line: 160 -->
<xsl:value-of  select="'&lt;'"/>

 <!-- Line: 161 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="substring-after( $txt, $lessThan )"/>


</xsl:call-template>

</xsl:when>
 <!-- Line: 165 -->
<xsl:when test="contains( $txt, $greaterThan )">
 <!-- Line: 166 -->
<xsl:value-of  select="substring-before( $txt, $greaterThan )"/>

 <!-- Line: 167 -->
<xsl:value-of  select="'&gt;'"/>

 <!-- Line: 168 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="substring-after( $txt, $greaterThan )"/>


</xsl:call-template>

</xsl:when>
 <!-- Line: 172 -->
<xsl:when test="contains( $txt, $ampersand )">
 <!-- Line: 173 -->
<xsl:value-of  select="substring-before( $txt, $ampersand )"/>

 <!-- Line: 174 -->
<xsl:value-of  select="$ampersand"/>

 <!-- Line: 175 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="substring-after( $txt, $ampersand )"/>


</xsl:call-template>

</xsl:when>
 <!-- Line: 179 -->
<xsl:otherwise>
 <!-- Line: 180 -->
<xsl:value-of  select="$txt"/>


</xsl:otherwise>

</xsl:choose>

</xsl:template>
 <!-- Line: 188 -->
<xsl:template name="pvwOutput">
 <!-- Line: 189 -->
<xsl:param  name="inName"/>

 <!-- Line: 190 -->
<xsl:param  name="inValue"/>

 <!-- Line: 191 -->
<xsl:param  name="inKeyword"/>

 <!-- Line: 192 -->
<xsl:param  name="spaces"/>

 <!-- Line: 194 -->
<xsl:variable  name="conditionedValue">
 <!-- Line: 195 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="$inValue"/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 200 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 201 -->
<xsl:variable  name="plainText" select="text()"/>

 <!-- Line: 202 -->
<xsl:variable  name="conditionedPlainText">
 <!-- Line: 203 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="$plainText"/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 208 -->
<xsl:choose>
 <!-- Line: 209 -->
<xsl:when test="$inValue">
 <!-- Line: 212 -->
<xsl:value-of  select="concat( $spaces, $inKeyword, $space, $inName, $space, $doubleQuote, $conditionedValue, $doubleQuote, $return )"/>


</xsl:when>
 <!-- Line: 214 -->
<xsl:when test="not( $inValue ) and not( . )">
 <!-- Line: 217 -->
<xsl:value-of  select="concat( $spaces, $inKeyword, $space, $inName, $space, $doubleQuote, $doubleQuote, $return )"/>


</xsl:when>
 <!-- Line: 219 -->
<xsl:otherwise>
 <!-- Line: 222 -->
<xsl:value-of  select="concat( $spaces, $inKeyword, $space, $inName )"/>

 <!-- Line: 223 -->
<xsl:choose>
 <!-- Line: 224 -->
<xsl:when test="not( *[1] )">
 <!-- Line: 225 -->
<xsl:if test="count( $plainText ) > 0">
 <!-- Line: 226 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 227 -->
<xsl:value-of  select="concat( $spaces, 'text ', $doubleQuote, $conditionedPlainText, $doubleQuote )"/>

 <!-- Line: 228 -->
<xsl:value-of  select="concat( $space, $closeCurlyBracket )"/>


</xsl:if>

</xsl:when>
 <!-- Line: 231 -->
<xsl:otherwise>
 <!-- Line: 233 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 234 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 237 -->
<xsl:value-of  select="concat( $space, $closeCurlyBracket )"/>


</xsl:otherwise>

</xsl:choose>
 <!-- Line: 240 -->
<xsl:value-of  select="$return"/>


</xsl:otherwise>

</xsl:choose>

</xsl:template>
 <!-- Line: 249 -->
<xsl:template  match="xsl:apply-imports">
 <!-- Line: 250 -->
<xsl:param  name="spaces"/>

 <!-- Line: 252 -->
<xsl:value-of  select="concat( $spaces, 'apply-imports', $return )"/>


</xsl:template>
 <!-- Line: 258 -->
<xsl:template  match="xsl:apply-templates">
 <!-- Line: 259 -->
<xsl:param  name="spaces"/>

 <!-- Line: 261 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 263 -->
<xsl:value-of  select="concat( $spaces, 'apply-templates ' )"/>

 <!-- Line: 264 -->
<xsl:if test="@select">
 <!-- Line: 265 -->
<xsl:value-of  select="concat( ' using ', $doubleQuote, @select, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 267 -->
<xsl:if test="@mode">
 <!-- Line: 268 -->
<xsl:value-of  select="concat( ' scope ', $doubleQuote, @mode, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 270 -->
<xsl:if test="./*">
 <!-- Line: 271 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 272 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 275 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket )"/>


</xsl:if>
 <!-- Line: 277 -->
<xsl:value-of  select="$return"/>


</xsl:template>
 <!-- Line: 283 -->
<xsl:template  match="xsl:attribute">
 <!-- Line: 284 -->
<xsl:param  name="spaces"/>

 <!-- Line: 286 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 287 -->
<xsl:variable  name="plainText" select="text()"/>

 <!-- Line: 289 -->
<xsl:value-of  select="concat( $spaces, 'attribute ', $doubleQuote, @name, $doubleQuote )"/>

 <!-- Line: 290 -->
<xsl:if test="@namespace">
 <!-- Line: 291 -->
<xsl:value-of  select="concat( ' namespace', $doubleQuote, @namespace, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 293 -->
<xsl:choose>
 <!-- Line: 294 -->
<xsl:when test="not( *[1] )">
 <!-- Line: 295 -->
<xsl:if test="count( $plainText ) > 0">
 <!-- Line: 296 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 297 -->
<xsl:value-of  select="concat( $newSpaces, 'text ', $doubleQuote, $plainText, $doubleQuote, $return )"/>

 <!-- Line: 298 -->
<xsl:value-of  select="concat(  $spaces, $closeCurlyBracket, $return )"/>


</xsl:if>

</xsl:when>
 <!-- Line: 301 -->
<xsl:otherwise>
 <!-- Line: 302 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 303 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 306 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket )"/>


</xsl:otherwise>

</xsl:choose>
 <!-- Line: 309 -->
<xsl:value-of  select="$return"/>


</xsl:template>
 <!-- Line: 315 -->
<xsl:template  match="xsl:attribute-set">
 <!-- Line: 316 -->
<xsl:param  name="spaces"/>

 <!-- Line: 318 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 319 -->
<xsl:variable  name="attributeName" select="@name"/>

 <!-- Line: 320 -->
<xsl:variable  name="useAttributeSets" select="@use-attribute-sets"/>

 <!-- Line: 321 -->
<xsl:variable  name="keyword" select="'attribute-set'"/>

 <!-- Line: 323 -->
<xsl:value-of  select="concat( $spaces, $keyword, $space, $doubleQuote, $attributeName, $doubleQuote )"/>

 <!-- Line: 324 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 325 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 328 -->
<xsl:value-of  select="concat( $spaces,'}' )"/>

 <!-- Line: 329 -->
<xsl:value-of  select="$return"/>


</xsl:template>
 <!-- Line: 335 -->
<xsl:template  match="xsl:call-template">
 <!-- Line: 336 -->
<xsl:param  name="spaces"/>

 <!-- Line: 338 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 339 -->
<xsl:variable  name="nameValue" select="@name"/>

 <!-- Line: 341 -->
<xsl:choose>
 <!-- Line: 342 -->
<xsl:when test="./*">
 <!-- Line: 343 -->
<xsl:value-of  select="concat( $spaces, 'call ', $nameValue, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 344 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 347 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:when>
 <!-- Line: 349 -->
<xsl:otherwise>
 <!-- Line: 350 -->
<xsl:value-of  select="concat( $spaces, 'call ', $nameValue, $return )"/>


</xsl:otherwise>

</xsl:choose>

</xsl:template>
 <!-- Line: 358 -->
<xsl:template  match="xsl:choose">
 <!-- Line: 359 -->
<xsl:param  name="spaces"/>

 <!-- Line: 361 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 363 -->
<xsl:value-of  select="concat( $spaces, 'choose {', $return )"/>

 <!-- Line: 364 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 367 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 373 -->
<xsl:template  match="xsl:comment">
 <!-- Line: 374 -->
<xsl:param  name="spaces"/>

 <!-- Line: 376 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 377 -->
<xsl:variable  name="keyword" select="'comment'"/>

 <!-- Line: 379 -->
<xsl:value-of  select="concat( $spaces, 'comment {', $return )"/>

 <!-- Line: 380 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 383 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 389 -->
<xsl:template  match="xsl:copy">
 <!-- Line: 390 -->
<xsl:param  name="spaces"/>

 <!-- Line: 392 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 393 -->
<xsl:variable  name="useAttributeSets" select="@use-attribute-sets"/>

 <!-- Line: 395 -->
<xsl:choose>
 <!-- Line: 396 -->
<xsl:when test="$useAttributeSets">
 <!-- Line: 397 -->
<xsl:value-of  select="concat( $spaces, 'copy use-attribute-sets', $useAttributeSets, $space, $openCurlyBracket, $return )"/>


</xsl:when>
 <!-- Line: 399 -->
<xsl:otherwise>
 <!-- Line: 400 -->
<xsl:value-of  select="concat( $spaces, 'copy {', $return )"/>


</xsl:otherwise>

</xsl:choose>
 <!-- Line: 403 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 406 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 412 -->
<xsl:template  match="xsl:copy-of">
 <!-- Line: 413 -->
<xsl:param  name="spaces"/>

 <!-- Line: 415 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 416 -->
<xsl:variable  name="selectValue" select="@select"/>

 <!-- Line: 418 -->
<xsl:value-of  select="concat( $spaces, 'copy-of ', $doubleQuote, $selectValue, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 424 -->
<xsl:template  match="xsl:decimal-format">
 <!-- Line: 425 -->
<xsl:param  name="spaces"/>

 <!-- Line: 427 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 429 -->
<xsl:value-of  select="concat( $return, $spaces, 'decimal-format ', $openCurlyBracket, $return )"/>

 <!-- Line: 430 -->
<xsl:if test="@name">
 <!-- Line: 431 -->
<xsl:value-of  select="concat( $newSpaces, 'name ', $doubleQuote, @name, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 433 -->
<xsl:if test="@decimal-separator">
 <!-- Line: 434 -->
<xsl:value-of  select="concat( $newSpaces, 'decimal-separator ', $doubleQuote, @decimal-separator, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 436 -->
<xsl:if test="@grouping-separator">
 <!-- Line: 437 -->
<xsl:value-of  select="concat( $newSpaces, 'grouping-separator ', $doubleQuote, @grouping-separator, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 439 -->
<xsl:if test="@infinity">
 <!-- Line: 440 -->
<xsl:value-of  select="concat( $newSpaces, 'infinity ', $doubleQuote, @infinity, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 442 -->
<xsl:if test="@minus-sign">
 <!-- Line: 443 -->
<xsl:value-of  select="concat( $newSpaces, 'minus-sign ', $doubleQuote, @minus-sign, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 445 -->
<xsl:if test="@NaN">
 <!-- Line: 446 -->
<xsl:value-of  select="concat( $newSpaces, 'NaN ', $doubleQuote, @NaN, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 448 -->
<xsl:if test="@percent">
 <!-- Line: 449 -->
<xsl:value-of  select="concat( $newSpaces, 'percent ', $doubleQuote, @percent, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 451 -->
<xsl:if test="@per-mille">
 <!-- Line: 452 -->
<xsl:value-of  select="concat( $newSpaces, 'per-mille ', $doubleQuote, @per-mille, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 454 -->
<xsl:if test="@zero-digit">
 <!-- Line: 455 -->
<xsl:value-of  select="concat( $newSpaces, 'zero-digit ', $doubleQuote, @zero-digit, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 457 -->
<xsl:if test="@digit">
 <!-- Line: 458 -->
<xsl:value-of  select="concat( $newSpaces, 'digit ', $doubleQuote, @digit, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 460 -->
<xsl:if test="@pattern-separator">
 <!-- Line: 461 -->
<xsl:value-of  select="concat( $newSpaces, 'pattern-separator ', $doubleQuote, @pattern-separator, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 463 -->
<xsl:value-of  select="concat( $return, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 470 -->
<xsl:template  match="xsl:element">
 <!-- Line: 471 -->
<xsl:param  name="spaces"/>

 <!-- Line: 473 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 474 -->
<xsl:variable  name="nameValue" select="@name"/>

 <!-- Line: 476 -->
<xsl:value-of  select="concat( $spaces, 'element ', $doubleQuote, $nameValue, $doubleQuote, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 477 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 480 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 486 -->
<xsl:template  match="xsl:for-each">
 <!-- Line: 487 -->
<xsl:param  name="spaces"/>

 <!-- Line: 489 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 490 -->
<xsl:variable  name="selectValue" select="@select"/>

 <!-- Line: 492 -->
<xsl:value-of  select="concat( $spaces, 'foreach ', $doubleQuote, $selectValue, $doubleQuote, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 493 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 496 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 502 -->
<xsl:template  match="xsl:if">
 <!-- Line: 503 -->
<xsl:param  name="spaces"/>

 <!-- Line: 505 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 506 -->
<xsl:variable  name="testValue" select="@test"/>

 <!-- Line: 507 -->
<xsl:variable  name="conditionedValue">
 <!-- Line: 508 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="$testValue"/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 513 -->
<xsl:value-of  select="concat( $spaces, 'if ', $doubleQuote, $conditionedValue, $doubleQuote, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 514 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 517 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 523 -->
<xsl:template  match="xsl:include">
 <!-- Line: 524 -->
<xsl:param  name="spaces"/>

 <!-- Line: 526 -->
<xsl:value-of  select="concat( $spaces, 'include ', $doubleQuote, @href, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 532 -->
<xsl:template  match="xsl:import">
 <!-- Line: 533 -->
<xsl:param  name="spaces"/>

 <!-- Line: 535 -->
<xsl:value-of  select="concat( $spaces, 'import ', $doubleQuote, @href, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 541 -->
<xsl:template  match="xsl:key">
 <!-- Line: 542 -->
<xsl:param  name="spaces"/>

 <!-- Line: 544 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 546 -->
<xsl:value-of  select="concat( $return, $spaces, 'key' )"/>

 <!-- Line: 547 -->
<xsl:value-of  select="concat( ' name ', $doubleQuote, @name, $doubleQuote )"/>

 <!-- Line: 548 -->
<xsl:value-of  select="concat( ' using ', $doubleQuote, @match, $doubleQuote )"/>

 <!-- Line: 549 -->
<xsl:value-of  select="concat( ' keyNodes ', $doubleQuote, @use, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 555 -->
<xsl:template  match="xsl:message">
 <!-- Line: 556 -->
<xsl:param  name="spaces"/>

 <!-- Line: 558 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 560 -->
<xsl:value-of  select="concat( $spaces, 'message' )"/>

 <!-- Line: 561 -->
<xsl:if test="@terminate">
 <!-- Line: 562 -->
<xsl:value-of  select="concat( ' terminate', $doubleQuote, @terminate, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 564 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 565 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 568 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 574 -->
<xsl:template  match="xsl:namespace-alias">
 <!-- Line: 575 -->
<xsl:param  name="spaces"/>

 <!-- Line: 577 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 579 -->
<xsl:value-of  select="concat( $return, $spaces, 'namespace-alias' )"/>

 <!-- Line: 580 -->
<xsl:value-of  select="concat( ' map-from ', $doubleQuote, @stylesheet-prefix, $doubleQuote )"/>

 <!-- Line: 581 -->
<xsl:value-of  select="concat( ' to ', $doubleQuote, @result-prefix, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 587 -->
<xsl:template  match="xsl:number">
 <!-- Line: 588 -->
<xsl:param  name="spaces"/>

 <!-- Line: 590 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 592 -->
<xsl:value-of  select="concat( $return, $spaces, 'number ', $openCurlyBracket, $return )"/>

 <!-- Line: 593 -->
<xsl:if test="@count">
 <!-- Line: 594 -->
<xsl:value-of  select="concat( $newSpaces, 'count ', $doubleQuote, @count, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 596 -->
<xsl:if test="@level">
 <!-- Line: 597 -->
<xsl:value-of  select="concat( $newSpaces, 'level ', @level, $return )"/>


</xsl:if>
 <!-- Line: 599 -->
<xsl:if test="@from">
 <!-- Line: 600 -->
<xsl:value-of  select="concat( $newSpaces, 'from ', $doubleQuote, @from, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 602 -->
<xsl:if test="@value">
 <!-- Line: 603 -->
<xsl:value-of  select="concat( $newSpaces, 'value ', $doubleQuote, @value, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 605 -->
<xsl:if test="@format">
 <!-- Line: 606 -->
<xsl:value-of  select="concat( $newSpaces, 'format ', $doubleQuote, @format, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 608 -->
<xsl:if test="@lang">
 <!-- Line: 609 -->
<xsl:value-of  select="concat( $newSpaces, 'lang ', $doubleQuote, @lang, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 611 -->
<xsl:if test="@letter-value">
 <!-- Line: 612 -->
<xsl:value-of  select="concat( $newSpaces, 'letter-value ', @letter-value, $return )"/>


</xsl:if>
 <!-- Line: 614 -->
<xsl:if test="@grouping-separator">
 <!-- Line: 615 -->
<xsl:value-of  select="concat( $newSpaces, 'grouping-separator ', $doubleQuote, @grouping-separator, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 617 -->
<xsl:if test="@grouping-size">
 <!-- Line: 618 -->
<xsl:value-of  select="concat( $newSpaces, 'grouping-size ', $doubleQuote, @grouping-size, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 620 -->
<xsl:value-of  select="concat( $return, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 626 -->
<xsl:template  match="xsl:otherwise">
 <!-- Line: 627 -->
<xsl:param  name="spaces"/>

 <!-- Line: 629 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 631 -->
<xsl:value-of  select="concat( $spaces, 'otherwise {', $return )"/>

 <!-- Line: 632 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 635 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 641 -->
<xsl:template  match="xsl:output">
 <!-- Line: 642 -->
<xsl:param  name="spaces"/>

 <!-- Line: 644 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 646 -->
<xsl:value-of  select="concat( $return, $spaces, 'output ', $openCurlyBracket, $return )"/>

 <!-- Line: 647 -->
<xsl:if test="@method">
 <!-- Line: 648 -->
<xsl:value-of  select="concat( $newSpaces, 'method ', @method, $return )"/>


</xsl:if>
 <!-- Line: 650 -->
<xsl:if test="@version">
 <!-- Line: 651 -->
<xsl:value-of  select="concat( $newSpaces, 'version ', $doubleQuote, @version, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 653 -->
<xsl:if test="@encoding">
 <!-- Line: 654 -->
<xsl:value-of  select="concat( $newSpaces, 'encoding ', $doubleQuote, @encoding, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 656 -->
<xsl:if test="@omit-xml-declaration">
 <!-- Line: 657 -->
<xsl:value-of  select="concat( $newSpaces, 'omit-xml-declaration ', @omit-xml-declaration, $return )"/>


</xsl:if>
 <!-- Line: 659 -->
<xsl:if test="@standalone">
 <!-- Line: 660 -->
<xsl:value-of  select="concat( $newSpaces, 'standalone ', @standalone, $return )"/>


</xsl:if>
 <!-- Line: 662 -->
<xsl:if test="@doctype-public">
 <!-- Line: 663 -->
<xsl:value-of  select="concat( $newSpaces, 'doctype-public ', $doubleQuote, @doctype-public, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 665 -->
<xsl:if test="@doctype-system">
 <!-- Line: 666 -->
<xsl:value-of  select="concat( $newSpaces, 'doctype-system ', $doubleQuote, @doctype-system, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 668 -->
<xsl:if test="@cdata-section-elements">
 <!-- Line: 669 -->
<xsl:value-of  select="concat( $newSpaces, 'cdata-section-elements ', $doubleQuote, @cdata-section-elements, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 671 -->
<xsl:if test="@indent">
 <!-- Line: 672 -->
<xsl:value-of  select="concat( $newSpaces, 'indent ', @indent, $return )"/>


</xsl:if>
 <!-- Line: 674 -->
<xsl:if test="@media-type">
 <!-- Line: 675 -->
<xsl:value-of  select="concat( $newSpaces, 'media-type ', $doubleQuote, @media-type, $doubleQuote, $return )"/>


</xsl:if>
 <!-- Line: 677 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return)"/>


</xsl:template>
 <!-- Line: 684 -->
<xsl:template  match="xsl:param">
 <!-- Line: 685 -->
<xsl:param  name="spaces"/>

 <!-- Line: 687 -->
<xsl:call-template name="pvwOutput">
 <xsl:with-param  name="inName" select="@name"/>

 <xsl:with-param  name="inValue" select="@select"/>

 <xsl:with-param  name="inKeyword" select="'parameter'"/>

 <xsl:with-param  name="spaces" select="$spaces"/>


</xsl:call-template>

</xsl:template>
 <!-- Line: 698 -->
<xsl:template  match="xsl:preserve-space">
 <!-- Line: 699 -->
<xsl:param  name="spaces"/>

 <!-- Line: 701 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 703 -->
<xsl:value-of  select="concat( $spaces, 'preserve-space ', $doubleQuote, @elements, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 709 -->
<xsl:template  match="xsl:processing-instruction">
 <!-- Line: 710 -->
<xsl:param  name="spaces"/>

 <!-- Line: 712 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 713 -->
<xsl:variable  name="nameValue" select="@name"/>

 <!-- Line: 715 -->
<xsl:value-of  select="concat( $spaces, 'processing-instruction ', $doubleQuote, $nameValue, $doubleQuote, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 716 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 719 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 725 -->
<xsl:template  match="xsl:sort">
 <!-- Line: 726 -->
<xsl:param  name="spaces"/>

 <!-- Line: 728 -->
<xsl:value-of  select="concat( $spaces, 'sort ' )"/>

 <!-- Line: 729 -->
<xsl:if test="@select">
 <!-- Line: 730 -->
<xsl:value-of  select="concat( ' using ', $doubleQuote, @select, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 732 -->
<xsl:if test="@order">
 <!-- Line: 733 -->
<xsl:value-of  select="concat( $space, @order )"/>


</xsl:if>
 <!-- Line: 735 -->
<xsl:if test="@case-order">
 <!-- Line: 736 -->
<xsl:value-of  select="concat( $space, @case-order )"/>


</xsl:if>
 <!-- Line: 738 -->
<xsl:if test="@lang">
 <!-- Line: 739 -->
<xsl:value-of  select="concat( ' lang ', $doubleQuote, @lang, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 741 -->
<xsl:if test="@data-type">
 <!-- Line: 743 -->
<xsl:value-of  select="concat( $space, @data-type, '-sort' )"/>


</xsl:if>
 <!-- Line: 745 -->
<xsl:value-of  select="$return"/>


</xsl:template>
 <!-- Line: 751 -->
<xsl:template  match="xsl:strip-space">
 <!-- Line: 752 -->
<xsl:param  name="spaces"/>

 <!-- Line: 754 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 756 -->
<xsl:value-of  select="concat( $spaces, 'strip-space ', $doubleQuote, @elements, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 762 -->
<xsl:template  match="xsl:template">
 <!-- Line: 763 -->
<xsl:param  name="spaces"/>

 <!-- Line: 765 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 767 -->
<xsl:choose>
 <!-- Line: 768 -->
<xsl:when test="@name">
 <!-- Line: 769 -->
<xsl:value-of  select="concat( $return, $spaces, 'proc ', @name, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 770 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 773 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:when>
 <!-- Line: 775 -->
<xsl:otherwise>
 <!-- Line: 776 -->
<xsl:value-of  select="concat( $return, $spaces, 'match ' )"/>

 <!-- Line: 777 -->
<xsl:if test="@match">
 <!-- Line: 778 -->
<xsl:value-of  select="concat( ' using ', $doubleQuote, @match, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 780 -->
<xsl:if test="@mode">
 <!-- Line: 781 -->
<xsl:value-of  select="concat( ' scope ', $doubleQuote, @mode, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 783 -->
<xsl:if test="@priority">
 <!-- Line: 784 -->
<xsl:value-of  select="concat( ' priority ', $doubleQuote, @priority, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 786 -->
<xsl:value-of  select="concat( $space, $openCurlyBracket, $return )"/>

 <!-- Line: 787 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 790 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:otherwise>

</xsl:choose>

</xsl:template>
 <!-- Line: 798 -->
<xsl:template  match="xsl:text">
 <!-- Line: 799 -->
<xsl:param  name="spaces"/>

 <!-- Line: 801 -->
<xsl:variable  name="conditionedText">
 <!-- Line: 802 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="."/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 807 -->
<xsl:value-of  select="concat( $spaces, 'text' )"/>

 <!-- Line: 808 -->
<xsl:if test="@disable-output-escaping">
 <!-- Line: 809 -->
<xsl:value-of  select="concat( ' disable-output-escaping', $doubleQuote, @disable-output-escaping, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 811 -->
<xsl:value-of  select="concat( $space, $doubleQuote, $conditionedText, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 817 -->
<xsl:template  match="xsl:value-of">
 <!-- Line: 818 -->
<xsl:param  name="spaces"/>

 <!-- Line: 820 -->
<xsl:value-of  select="concat( $spaces, 'value ', $doubleQuote, @select, $doubleQuote, $return )"/>


</xsl:template>
 <!-- Line: 826 -->
<xsl:template  match="xsl:variable">
 <!-- Line: 827 -->
<xsl:param  name="spaces"/>

 <!-- Line: 829 -->
<xsl:call-template name="pvwOutput">
 <xsl:with-param  name="inName" select="@name"/>

 <xsl:with-param  name="inValue" select="@select"/>

 <xsl:with-param  name="inKeyword" select="'variable'"/>

 <xsl:with-param  name="spaces" select="$spaces"/>


</xsl:call-template>

</xsl:template>
 <!-- Line: 840 -->
<xsl:template  match="xsl:when">
 <!-- Line: 841 -->
<xsl:param  name="spaces"/>

 <!-- Line: 843 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 844 -->
<xsl:variable  name="conditionedValue">
 <!-- Line: 845 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="@test"/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 849 -->
<xsl:value-of  select="concat( $spaces, 'when ', $doubleQuote, $conditionedValue, $doubleQuote, $space, $openCurlyBracket, $return )"/>

 <!-- Line: 850 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 853 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 859 -->
<xsl:template  match="xsl:with-param">
 <!-- Line: 860 -->
<xsl:param  name="spaces"/>

 <!-- Line: 862 -->
<xsl:call-template name="pvwOutput">
 <xsl:with-param  name="inName" select="@name"/>

 <xsl:with-param  name="inValue" select="@select"/>

 <xsl:with-param  name="inKeyword" select="'with'"/>

 <xsl:with-param  name="spaces" select="$spaces"/>


</xsl:call-template>

</xsl:template>
 <!-- Line: 873 -->
<xsl:template  match="xsl:fallback">
 <!-- Line: 874 -->
<xsl:param  name="spaces"/>

 <!-- Line: 876 -->
<xsl:variable  name="newSpaces" select="concat( $spaces, $identSpaces )"/>

 <!-- Line: 878 -->
<xsl:value-of  select="concat( $spaces, 'fallback {', $return )"/>

 <!-- Line: 879 -->
<xsl:apply-templates  select="./*">
 <xsl:with-param  name="spaces" select="$newSpaces"/>


</xsl:apply-templates>
 <!-- Line: 882 -->
<xsl:value-of  select="concat( $spaces, $closeCurlyBracket, $return )"/>


</xsl:template>
 <!-- Line: 889 -->
<xsl:template  match="xsl:script">
 <!-- Line: 890 -->
<xsl:param  name="spaces"/>

 <!-- Line: 892 -->
<xsl:value-of  select="concat( $spaces, 'script' )"/>

 <!-- Line: 893 -->
<xsl:if test="@implements-prefix">
 <!-- Line: 894 -->
<xsl:value-of  select="concat( ' prefix ', $doubleQuote, @implements-prefix, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 896 -->
<xsl:if test="@language">
 <!-- Line: 897 -->
<xsl:value-of  select="concat( ' language ', $doubleQuote, @language, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 899 -->
<xsl:if test="@src">
 <!-- Line: 900 -->
<xsl:value-of  select="concat( ' src ', $doubleQuote, @src, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 902 -->
<xsl:if test="@archive">
 <!-- Line: 903 -->
<xsl:value-of  select="concat( ' archive ', $doubleQuote, @archive, $doubleQuote )"/>


</xsl:if>
 <!-- Line: 906 -->
<xsl:if test=".">
 <!-- Line: 907 -->
<xsl:variable  name="conditionedText">
 <!-- Line: 908 -->
<xsl:call-template name="replaceStrings">
 <xsl:with-param  name="txt" select="."/>


</xsl:call-template>

</xsl:variable>
 <!-- Line: 912 -->
<xsl:value-of  select="concat( $space, $doubleQuote, $conditionedText, $doubleQuote, $return )"/>


</xsl:if>

</xsl:template>
 <!-- Line: 923 -->
<xsl:template  match="node() | @*"/>


</xsl:stylesheet>
