//
//  ListingView.swift
//  RexselEditor
//
//  Created by Hugh Field-Richards on 30/10/2024.
//  Copyright 2025 Hugh Field-Richards. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  https://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//
// This is the XSL listing view for the app.

import SwiftUI

struct ListingView: View {
    
    /// The compiled XSL text.
    @Binding var listingText: String
    
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
    // MARK: - Main view
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
    // -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

    var body: some View {
        VStack {
            HStack { // Top right window
                VStack {
                   TextEditor( text: .constant( listingText ) )
                        .font( .custom( "Monaco", size: 12 ) )
                        .padding( .bottom )
                }
            }
        }
   }
}

// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// MARK: - Preview
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

#Preview {
    let someListingText = """
<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
   version="1.0" xmlns:php="http://php.net/xsl"
   xmlns:sch="http://www.ascc.net/xml/schematron"
   xmlns:xhtml="http://www.w3.org/1999/xhtml"
   xmlns:dc="http://purl.org/dc/elements/1.1/"
   xmlns:a="http://relaxng.org/ns/annotation/1.0"
   xmlns:rng="http://relaxng.org/ns/structure/1.0">
   <!-- Line: 36 -->
   <xsl:output version="1.0" encoding="UTF-8"/>

   <!-- Line: 45 -->
   <xsl:param name="stylesDir"/>

   <!-- Line: 46 -->
   <xsl:param name="scriptsDir"/>

   <!-- Line: 47 -->
   <xsl:param name="jQueryScriptsDir"/>

   <!-- Line: 53 -->
   <xsl:variable name="gCSSFiles" select="'prettySchematron.css,prettyRNG.css'"/>

   <!-- Line: 54 -->
   <xsl:variable name="gScriptFiles" select="'rng.js'"/>

   <!-- Line: 55 -->
   <xsl:variable name="gJQueryScriptFiles" select="'jquery.min.js;jquery-ui-1.8.16.custom.min.js'"/>

   <!-- Line: 61 -->
   <xsl:variable name="gCSSFilesDir" select="$stylesDir"/>

   <!-- Line: 62 -->
   <xsl:variable name="gScriptFilesDir" select="$scriptsDir"/>

   <!-- Line: 63 -->
   <xsl:variable name="gJQueryScriptFilesDir" select="$jQueryScriptsDir"/>

   <!-- Line: 70 -->
   <xsl:include href="schematron2xhtml.xsl"/>

"""
   
    ListingView( listingText: .constant( someListingText ) )
}

